% MATLAB code: Example 12.3
% File: Granite.m
% library: lagmatrix (e.g. Econometrics toolbox) 
%
% Part 1)
% INPUT:
%   index_n1825.dat (1825 *1) vector renamed as "index" below
%   ygranite.dat (1825 * 1) vector 
%
% OUTPUT: b = (2.48258087671234 -0.0906748149322354 0.0460136188836473)' 
%         RESID.dat  (1825 * 1) vector
% 
% Part 2)
% INPUT:
%   input.dat = (log(SST) WD2 log(WS)  WD)'
%               a  matrix of dimension (1825 * 4)
%   RESID.dat = (1825 * 1) vector
% OUTPUT:
%   YPPRresp (1825 * 2) modified into file YPPRresponse.dat (1816 * 2) 
%           by omitting the first nine rows.
%   xmatSST (1825 *5) modified into file xmatSST.dat (1816 * 5)
%           by omitting the first nine rows.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Part 1)
x1 = sin(2*pi*index/365);
x2 = cos(2*pi*index/365);
X  = [ones(size(index)) x1 x2];
[b,SIGMA,RESID] = mvrgess(X,ygranite);

% Part 2)
YPPRresp = [RESID, input(:,3)];     % (1825 * 2) matrix

ylag     = lagmatrix(RESID,1);
xd2lag   = lagmatrix(input(:,2),1); % wind direction (WD2), lag 1
wslag    = lagmatrix(input(:,3),1); % wind speed (log(WS)), lag 1
wslag4   = lagmatrix(input(:,3),4); %   ,,                , lag 4
wslag9   = lagmatrix(input(:,3),9); %   ,,                , lag 9
xmatSST  = [ylag, wslag, xd2lag, wslag4, wslag9]; % (1825 * 5) matrix